<?php
Class Site extends CI_Controller{

     function __construct()
    {
	 parent::__construct();
	 $this->load->model('View_data');
	 $this->load->helper(array('html','language','form','text'));
	 $this->load->helper('my_helper');
	 $this->load->model('Search_data');
	 $this->load->model('Common_model');
	 $this->load->library('form_validation');
    }

     public function index()
    {
       $data['title'] = 'Shreekrishna Engg ';
       $data['description'] = '';
       $data['keywords'] = '';
       $data['slider'] = $this->View_data->getslider();
       $data['page'] = 'index';
	   $data['about'] = $this->View_data->about(); 
	   $data['testimonials'] = $this->View_data->get_testmonial();
	   $data['clients'] = $this->View_data->get_client_home();
	   //$data['client_projects'] = $this->View_data->get_client_projects_random();
       $this->load->view('Frontend/index', $data);
    }

     public function career()
    {
       $data['title'] = 'Shreekrishna Engg ';
       $data['description'] = '';
       $data['keywords'] = '';
       $data['page'] = 'index';
	   $data['about'] = $this->View_data->about(); 
       $this->load->view('Frontend/career', $data);
    }

     public function thumb()
    {
    	$records = $this->View_data->get_service();
    	foreach($records as $row):
    		$sid = $row->s_id;
    	endforeach;
    }

    

 

    

    
    public function testimonials()
    {
       $data['title'] = 'Shreekrishna Engg ';
       $data['description'] = '';
       $data['keywords'] = '';
       $data['page'] = 'index';
	   $data['about'] = $this->View_data->about();
	   $data['testimonials'] = $this->View_data->get_testmonial();
       $this->load->view('Frontend/client-testimonials', $data);
    }

    


   
	
    public function sitemap()
    {
      $this->load->view('sitemap');
    }


	  public function vission()
    {
      $data['title'] = 'Vission & Mission';
      $data['page'] = 'Home';
	  $data['vision'] = $this->Common_model->select_by_id('a_title', 'Vision', 'articles');
      $this->load->view('Frontend/vission', $data);
    }

     public function products($name, $pt_id)
    {
      $data['title'] = 'Nashik Vegiculture';
      $data['page'] = 'product';
      $data['name'] = rm_dash($name);
      $data['contact'] = $this->View_data->getprofile();
      $data['products'] = $this->View_data->get_pcategory(); 
      $data['subproducts'] = $this->View_data->getall_products_id(base64_decode($pt_id)); 

           
      $data['about'] = $this->View_data->about();
      $this->load->view('Frontend/products',$data);
    }

	public function disclaimer()
	{
	 $data['title'] = 'Shreekrishna Engg : Disclaimer ';
	 $data['page'] = 'Shop-Cart';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $a_title = 'DISCLAIMER';
	 $data['record'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	 $this->load->view('Frontend/disclaimer', $data);
    }

    public function privacy()
	{
	 $data['title'] = 'Shreekrishna Engg : Privacy Policy ';
	 $data['page'] = 'Shop-Cart';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['services'] = $this->View_data->get_service();
	 $a_title = 'PRIVACY';
	 $data['record'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	 $this->load->view('Frontend/privacy-policy', $data);
    }
    public function refund()
	{
	 $data['title'] = 'Shreekrishna Engg : Privacy Policy ';
	 $data['page'] = 'Shop-Cart';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['services'] = $this->View_data->get_service();
	 $a_title = 'RETURN POLICY';
	 $data['record'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	 $this->load->view('Frontend/refund-policy', $data);
    }

    public function delivery()
	{
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['page'] = 'Shop-Cart';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $a_title = 'delivary';
	 $data['delivery'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	 $this->load->view('Frontend/delivery', $data);
    }
    
	 
    public function terms()
	{
	 $data['title'] = 'Shreekrishna Engg : Terms & Conditions ';
	 $data['page'] = 'terms';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $a_title = 'terms';
	 $data['terms'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	 $this->load->view('Frontend/terms', $data);
    }

    public function about()
    {
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['page'] = 'About';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['about'] = $this->View_data->about(); 
	 $this->load->view('Frontend/about', $data);
    }
    public function basic()
    {
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['page'] = 'About';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $a_title = 'Basic';
	 $data['record'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	 $this->load->view('Frontend/basic-profile', $data);
    }

    public function statutory()
    {
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['page'] = 'About';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $a_title = 'Statutory';
	 $data['record'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');

	 $this->load->view('Frontend/statutory-profile', $data);
    }

    public function facilities()
    {
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['page'] = 'About';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['about'] = $this->View_data->about(); 
	 $a_title = 'Facilities';
	 $data['record'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	 $this->load->view('Frontend/facilities', $data);
    } 

    public function infrastructure()
    {
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['page'] = 'About';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['about'] = $this->View_data->about(); 
	 $a_title = 'Infrastructure';
	 $data['record'] = $this->Common_model->select_by_id('a_title', $a_title, 'articles');
	 $this->load->view('Frontend/infrastructure', $data);
    }


    public function gallery()
    {
	 $gt_type = $this->View_data->get_gtype_home();
	 foreach($gt_type as $row);
	 $g_url = base_url().'gallery-type/'.rm_blank($row->gt_type).'/'.base64_encode($row->gt_id);
	 redirect($g_url, 'location');
    }

     public function gallerytype($name, $type)
    {
	 $data['title'] = 'Gallery ';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['page'] = 'Gallery';
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['name'] = rm_blank($name);
	 $data['gt_type'] = array_reverse($this->View_data->get_gtype_home());
	 $data['gallery'] = $this->View_data->get_gallery_id(base64_decode($type));
	 $this->load->view('Frontend/gallery',$data);
    }

     public function other()
    {
	 $data['title'] = 'Gallery ';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['page'] = 'Gallery';
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['gallery'] = $this->View_data->get_gallery_id('19');
	 $this->load->view('Frontend/other-products',$data);
    }

    

    public function projects($name, $c_id)
    {
	 $data['title'] = 'Gallery ';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['page'] = 'Gallery';
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['name'] = rm_blank($name);
	 $data['projects'] = $this->View_data->get_projects(base64_decode($c_id));
	 $this->load->view('Frontend/projects',$data);
    }

    


    
      public function contact()
   {
	 $data['title'] = ' Contact Us';
	 $data['page'] = 'Contact';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $this->load->view('Frontend/contact',$data);
   }
    public function search()
  {
    if(!empty($_POST["search"])) {
		$query ="SELECT * FROM product WHERE p_name like '%" . $_POST["search"] . "%' ORDER BY p_id LIMIT 0,6";
		//$result = $db_handle->runQuery($query);
		$result = $this->db->query($query)->result();
    echo "<ul>";
    if(!empty($result)) {

		foreach($result as $country) {
			echo "<li><a href='".base_url().'product-details/'.rm_blank($country->p_name)."/".base64_encode($country->p_id)."'>".trim($country->p_name)."</a></li>";
		}

		}
		else {
			echo '<li>No Results Found. <small style=color:#0083c9>Please Search Another Keywords....</small></li>';
		}
    }
    echo "</ul>";
  }

    public function blog($name,$id)
	{
      $data['title'] = ' : Blogs ';
      $data['page'] = 'Product';
	  $data['blog'] = $this->Common_model->select_where2_in('id',base64_decode($id),'b_status','1','blogs');
      $this->load->view('Frontend/blog', $data);
    }

    public function blogs()
	{
      $data['title'] = ' : Blogs ';
      $data['page'] = 'Product';
	  $data['blogs'] = $this->Common_model->select_where_in('b_status','1','blogs');
      $this->load->view('Frontend/blogs', $data);
    }

	 public function search_blogs()
	{
	 $name = $this->input->post('search');
	 $data['search'] =$this->Search_data->search($name);
	 $data['category'] = $this->View_data->get_category();
	 $data['blogs'] = $this->View_data->get_blogs();
	 $this->load->view('Frontend/search',$data);
  }

 public function product($p_name, $p_id)
    {
      $data['title'] = 'Nashik Vegiculture';
    	$data['page'] = 'product';
      $data['p_name'] = rm_dash($p_name);
      $data['contact'] = $this->View_data->getprofile();
  	  
  	  $data['product_cat'] = $this->View_data->get_pcategory();
      $data['category'] = $this->View_data->getsub_products_id(base64_decode($p_id));
  	  $data['name'] = str_replace('-',' ',$p_name);

  	  $data['product'] = $this->View_data->getsub_products_id(base64_decode($p_id));
  	  $data['about'] = $this->View_data->about();
      $this->load->view('Frontend/product',$data);
    }

  
	public function service($s_name, $s_id)
  {
	 $data['title'] = str_replace('-',' ',$s_name);
	 $s_name =str_replace('-',' ',$s_name);
	 $data['page'] = 'Service';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['service'] = $this->View_data->getservice_id(base64_decode($s_id));
	 // $data['servicegallery'] = $this->View_data->get_service_img(base64_decode($s_id));

	 $this->load->view('Frontend/service',$data);
  }

  	public function services()
  {
	 $data['page'] = 'Service';
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['services'] = $this->View_data->get_service();
	 $this->load->view('Frontend/services',$data);
  }


  public function clients()
  {
	 $data['page'] = 'Service';
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['clients'] = $this->View_data->get_client_projects();
	 $this->load->view('Frontend/clients',$data);
  }

 


 
  

  public function video()
    {
	 $data['title'] = 'Shreekrishna Engg ';
	 $data['page'] = 'Video';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['video'] = $this->View_data->get_video();
	 $this->load->view('Frontend/video',$data);
    }

  public function team()
  {
	$data['title'] = 'Shreekrishna Engg ';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $data['team'] = $this->Common_model->select_where_in('t_status','1','team');
	 $this->load->view('Frontend/team',$data);
  }

 public function feedback()
   {
	 $data['title'] = ' Feedback ';
	 $data['page'] = 'Contact';
	 $data['description'] = '';
	 $data['keywords'] = '';
	 $this->load->view('Frontend/feedback',$data);
   }


}
